/**
 * URM – User Logic
 *
 * Provides core access control functions for the User Role Membership system.
 * Includes route validation, role history storage, and admin view permissions.
 * Used internally by other URM modules to secure functionality.
 *
 * Author: Black & Copilot
 */

// 👥 URM - User logic

function urm_global_guard() {
    if (!is_user_logged_in() || !current_user_can('manage_options')) {
        wp_die('⛔ You do not have sufficient permission to access URM functions.');
    }
}

function save_ur_user_role_history($user_id, $role, $duration, $start, $end) {
    $history = get_user_meta($user_id, 'ur_role_history', true);
    if (!is_array($history)) $history = [];

    $history[] = [
        'role'     => $role,
        'duration' => $duration,
        'start'    => $start,
        'end'      => $end
    ];

    update_user_meta($user_id, 'ur_role_history', $history);
}

function urm_guard_router_integrity() {
    $valid_tabs = ['dashboard', 'log', 'users', 'help'];
    $active = $_GET['tab'] ?? 'dashboard';
    if (!in_array($active, $valid_tabs)) {
        wp_die('⛔ The requested tab is invalid.');
    }
}

function urm_guard_admin_view() {
    if (!current_user_can('manage_options')) {
        add_to_ur_process_log('❌ Unauthorized attempt to access the log view.', 'warning');
        wp_die('⛔ Access allowed only to administrators.');
    }
}
